//  Listing 10.2. Przykad przeciania funkcji operatorowych

#include <iostream>
using namespace std;

struct Complex             	// typ zdefiniowany przez programist
{ 
  double real, imag; 
} ;

Complex operator+(const Complex &a, const Complex &b) 	// magiczna nazwa
{ 
  Complex c; 			// lokalny obiekt
  c.real = a.real + b.real; 	// dodawanie czci rzeczywistych
  c.imag = a.imag + b.imag; 	// dodawanie czci urojonych
  return c; 
}

void operator += (Complex &a, const Complex &b) 	// inna magiczna nazwa
{ 
  a.real = a.real + b.real; 	// dodawanie czci rzeczywistych
  a.imag = a.imag + b.imag;  	// dodawanie czci urojonych
}

void operator += (Complex &a, double b) 		// inny interfejs
  { a.real += b; } 		// dodanie tylko czci rzeczywistych

void showComplex(const Complex &x)
{ 
  cout << "(" << x.real << ", " << x.imag << ")" << endl; 
}

int main()
{ 
  Complex x, y, z1, z2; 	// obiekty typu Complex
  x.real = 20; x.imag = 40; 	// inicjowanie
  y.real = 30; y.imag = 50;
  cout << " Pierwsza warto: "; 
    showComplex(x);
  cout << " Druga warto: "; 
    showComplex(y);
  z1 = operator+(x,y); 		// zastosowanie w wywoaniu funkcji
  cout << " Suma jako wynik wywoania funkcji: "; 
    showComplex(z1);
  z2 = x + y; 			// zastosowanie operatora
  cout << " Suma jako wynik dziaania operatora: "; 
    showComplex(z1);
  z1 += x; 			// to jest to samo, co operator+=(z1,x);
  cout << " Dodanie pierwszej wartoci do sumy: "; 
    showComplex(z1);
  z2 += 30.0; 			// to jest to samo, co operator+=(z2,30.0);
  cout << " Dodanie liczby 30 do sumy: "; 
    showComplex(z2);
  return 0;
}
